<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

function integrity()
{
	$result = true;
	$files = array
	(
		'settings.ini',
		'template/header.txt',
		'template/body-1.txt',
		'template/body-2.txt',
		'template/footer.txt',
		'template/header.html',
		'template/body-1.html',
		'template/body-2.html',
		'template/footer.html',
	);
	foreach($files as &$file) 
	{
		if (is_readable($file) === false)
		{
			error_log('[' . date('Y.m.d H:i:s') . '] "' . basename($file) . '" is not acccessible.' . chr(13) . chr(10), 3, 'error.log');
			$result = false;
		}
	}
	return $result;
}

function domain_validity(&$domain)
{
	$pattern = '/^(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/iDu';
	return
	(
		(is_string($domain) === true)
		&&
		(strlen($domain) <= 256)
		&&
		(preg_match($pattern, $domain) === 1)
	);
}

function email_validity(&$email)
{
	$pattern = '/^(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){255,})(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){65,}@)(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E\p{L}\p{N}]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F\p{L}\p{N}]|(?:\x5C[\x00-\x7F]))*\x22))(?:\.(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E\p{L}\p{N}]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F\p{L}\p{N}]|(?:\x5C[\x00-\x7F]))*\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/iDu';
	return
	(
		(is_string($email) === true)
		&&
		(strlen($email) <= 320)
		&&
		(preg_match($pattern, $email) === 1)
	);
}

function conformity(&$settings)
{
	$result = true;
	if (session_status() === PHP_SESSION_DISABLED)
	{
		error_log('[' . date('Y.m.d H:i:s') . '] Session support is not available.' . chr(13) . chr(10), 3, 'error.log');
		$result = false;
	}
	$settings = parse_ini_file('settings.ini', false, INI_SCANNER_TYPED);
	foreach(['domain-whitelist', 'domain-blacklist'] as &$variable)
	{
		if
		(
			(is_array($settings[$variable]) === true)
			&&
			($settings[$variable] !== [''])
			&&
			(in_array(false, array_map('domain_validity', $settings[$variable])) === true)
		)
		{
			$variables[] = $variable + '[]';
		}
	}
	foreach(['email-whitelist', 'email-blacklist'] as &$variable)
	{
		if
		(
			(is_array($settings[$variable]) === true)
			&&
			($settings[$variable] !== [''])
			&&
			(in_array(false, array_map('email_validity', $settings[$variable])) === true)
		)
		{
			$variables[] = $variable + '[]';
		}
	}
	if
	(
		(is_array($settings['recipients']) === false)
		||
		(in_array(false, array_map('email_validity', $settings['recipients'])) === true)
	)
	{
		$variables[] = 'recipients[]';
	}
	if (email_validity($settings['sender']) === false)
	{
		$variables[] = 'sender';
	}
	if (filter_var($settings['hostname'], FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME) === false)
	{
		$variables[] = 'hostname';
	}
	if
	(
		(is_int($settings['port']) === false)
		||
		($settings['port'] < 1)
		||
		($settings['port'] > 65535)
	)
	{
		$variables[] = 'port';
	}
	if
	(
		($settings['encryption'] !== '')
		&&
		($settings['encryption'] !== 'SSL/TLS')
		&&
		($settings['encryption'] !== 'STARTTLS')
	)
	{
		$variables[] = 'encryption';
	}
	if (is_bool($settings['authentication']) === false)
	{
		$variables[] = 'authentication';
	}
	else if ($settings['authentication'] === true)
	{
		foreach(['username', 'password'] as &$variable)
		{
			if
			(
				(is_string($settings[$variable]) === false)
				||
				($settings[$variable] === '')
			)
			{
				$variables[] = $variable;
			}
		}
	}
	if (filter_var($settings['url'], FILTER_VALIDATE_URL) === false)
	{
		$variables[] = 'url';
	}
	foreach($variables as &$variable)
	{
		error_log('[' . date('Y.m.d H:i:s') . '] "' . $variable . '" is not properly set in settings.ini.' . chr(13) . chr(10), 3, 'error.log');
		$result = false;
	}
	return $result;
}

function send(&$settings, &$title, &$text, &$html, &$sender, &$recipients)
{
	require 'PHPMailer/src/PHPMailer.php';
	require 'PHPMailer/src/SMTP.php';
	require 'PHPMailer/src/Exception.php';
	$mail = new PHPMailer();
	$mail->isSMTP();
	$mail->SMTPDebug = SMTP::DEBUG_OFF;
	$mail->validator = 'email_validity';
	$mail->Host =& $settings['hostname'];
	$mail->Port =& $settings['port'];
	if ($settings['encryption'] === 'SSL/TLS')
	{
		$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
	}
	else if ($settings['encryption'] === 'STARTTLS')
	{
		$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
	}
	$mail->SMTPAuth =& $settings['authentication'];
	$mail->Username =& $settings['username'];
	$mail->Password =& $settings['password'];
	$mail->CharSet = PHPMailer::CHARSET_UTF8;
	$mail->setFrom($sender, 'Contact form');
	foreach($recipients as &$recipient)
	{
		$mail->addAddress($recipient);
	}
	$mail->Subject =& $title;
	$mail->Body =& $html;
	$mail->AltBody =& $text;
	return $mail->send();
}

$query = json_decode(file_get_contents('php://input'), true);
if
(
	(integrity() === false)
	||
	(conformity($settings) === false)
)
{
	http_response_code(500);
}
else if ($query['action'] === 'code')
{
	if
	(
		(is_string($query['email']) === false)
		||
		($query['email'] === '')
	)
	{
		echo 'email';
	}
	else if
	(
		(email_validity($query['email']) === false)
		||
		(
			(
				(
					(is_array($settings['domain-whitelist']) === true)
					&&
					($settings['domain-whitelist'] !== [''])
				)
				||
				(
					(is_array($settings['email-whitelist']) === true)
					&&
					($settings['email-whitelist'] !== [''])
				)
			)
			&&
			(in_array(strtolower(substr($query['email'], strrpos($query['email'], '@') + 1)), array_map('strtolower', $settings['domain-whitelist']), true) !== true)
			&&
			(in_array(strtolower($query['email']), array_map('strtolower', $settings['email-whitelist']), true) !== true)
		)
		||
		(
			(is_array($settings['domain-blacklist']) === true)
			&&
			(in_array(strtolower(substr($query['email'], strrpos($query['email'], '@') + 1)), array_map('strtolower', $settings['domain-blacklist']), true) === true)
		)
		||
		(
			(is_array($settings['email-blacklist']) === true)
			&&
			(in_array(strtolower($query['email']), array_map('strtolower', $settings['email-blacklist']), true) === true)
		)
	)
	{
		echo 'wrong';
	}
	else
	{
		session_start();
		if ($_SESSION['time'] + 30 > time())
		{
			session_write_close();
			echo 'rate';
		}
		else
		{
			if ($_SESSION['email'] !== $query['email'])
			{
				$_SESSION['email'] =& $query['email'];
				$_SESSION['code'] = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
			}
			$title = 'Confirmation code';
			$label_2 = 'Confirmation code:';
			$content_2 =& $_SESSION['code'];
			ob_start();
			include('template/header.txt');
			include('template/body-2.txt');
			include('template/footer.txt');
			$text = ob_get_contents();
			ob_end_clean();
			ob_start();
			include('template/header.html');
			include('template/body-2.html');
			include('template/footer.html');
			$html = ob_get_contents();
			ob_end_clean();
			$recipients = [$query['email']];
			if (send($settings, $title, $text, $html, $settings['sender'], $recipients) === true)
			{
				$_SESSION['time'] = time();
				session_write_close();
				echo 'code';
			}
			else
			{
				session_destroy();
				echo 'error';
			}
		}
	}
}
else if ($query['action'] === 'send')
{
	session_start();
	if
	(
		(is_string($query['email']) === false)
		||
		($query['email'] === '')
		||
		(is_string($query['code']) === false)
		||
		($query['code'] === '')
		||
		(is_string($query['text']) === false)
		||
		($query['text'] === '')
	)
	{
		session_write_close();
		echo 'empty';
	}
	else if
	(
		($query['email'] !== $_SESSION['email'])
		||
		($query['code'] !== $_SESSION['code'])
	)
	{
		session_write_close();
		echo 'guest';
	}
	else if
	(
		(is_string($query['text']) === false)
		||
		(preg_match_all('/[\p{L}\p{N}_]+/u',$query['text']) < 10)
	)
	{
		session_write_close();
		echo 'short';
	}
	else
	{
		$title = 'New message';
		$label_1 = 'eMail address:';
		$content_1 = htmlspecialchars($query['email']);
		$label_2 = 'Message:';
		$content_2 = nl2br(htmlspecialchars($query['text']), false);
		ob_start();
		include('template/header.txt');
		if ($query['incog'] !== 'true')
		{
			include('template/body-1.txt');
		}
		include('template/body-2.txt');
		include('template/footer.txt');
		$text = ob_get_contents();
		ob_end_clean();
		ob_start();
		include('template/header.html');
		if ($query['incog'] !== 'true')
		{
			include('template/body-1.html');
		}
		include('template/body-2.html');
		include('template/footer.html');
		$html = ob_get_contents();
		ob_end_clean();
		if (send($settings, $title, $text, $html, $settings['sender'], $settings['recipients']) === true)
		{
			session_destroy();
			echo 'sent';
		}
		else
		{
			session_write_close();
			echo 'error';
		}
	}
}
?>
