function halt(disabled)
{
	for (const node of document.getElementsByClassName('submit'))
	{
		node.disabled = disabled;
	}
}

function info(code)
{
	const message =
	{
		'email': 'Please enter a <strong>valid eMail address</strong>.',
		'wrong': 'The eMail address provided is <strong>invalid or not allowed</strong>.',
		'rate': 'Please wait <strong>at least 30 seconds</strong> before making another request.',
		'vague': 'Unexpected response from the server.<br><br>Please <strong>try again later</strong>.',
		'wait': 'Your request is being processed.<br><br>Please <strong>wait for the result</strong>.',
		'code': 'A confirmation code has been <strong>successfully sent</strong> to Your eMail address.',
		'error': 'An error occurred while sending.<br><br>Please <strong>try again later</strong>.',
		'empty': 'Please fill in <strong>all required fields</strong> marked with an asterisk.',
		'short': 'The message must contain <strong>at least 10 words</strong>.',
		'sent': 'Your message has been <strong>successfully sent</strong>.',
		'guest': 'The eMail address and code <strong>do not match</strong>, or the session <strong>has expired</strong>.'
	};
	if (typeof(message[code]) === 'undefined') 
	{
		code = 'vague';
	}
	document.getElementById('dim').classList.remove('active');
	document.getElementById('alert-text').innerHTML = message[code];
	if (code === 'wait')
	{
		document.getElementById('alert-close').classList.remove('active');
	}
	else
	{
		document.getElementById('alert-close').classList.add('active');
	}
	document.getElementById('dim').classList.add('active');
	document.getElementById('alert-ok').focus();
}

async function code()
{
	halt(true);
	const email = /^(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){255,})(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){65,}@)(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E\p{L}\p{N}]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F\p{L}\p{N}]|(?:\x5C[\x00-\x7F]))*\x22))(?:\.(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E\p{L}\p{N}]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F\p{L}\p{N}]|(?:\x5C[\x00-\x7F]))*\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/iu;
	if (document.getElementById('email').value.length === 0)
	{
		info('email');
	}
	else if
	(
		(document.getElementById('email').value.length > 320)
		||
		(email.test(document.getElementById('email').value) === false)
	)
	{
		info('wrong');
	}
	else if (Number(localStorage.getItem('time')) + 30000 > Date.now())
	{
		info('rate');
	}
	else
	{
		const request = new Request
		(
			'submit.php',
			{
				'method': 'POST',
				'headers':
				{
					'Content-Type': 'application/json'
				},
				'body': JSON.stringify
				(
					{
						'action': 'code',
						'email': document.getElementById('email').value
					}
				)
			}
		);
		info('wait');
		const result = await fetch(request);
		if (result.ok === true)
		{
			const content = await result.text();
			if (content === 'code')
			{
				localStorage.setItem('time', Date.now());
			}
			info(content);
		}
		else
		{
			info('vague');
		}
	}
}

async function send()
{
	halt(true);
	if
	(
		(document.getElementById('email').value.length === 0) ||
		(document.getElementById('code').value.length === 0) ||
		(document.getElementById('text').value.length === 0)
	)
	{
		info('empty');
	}
	else if (document.getElementById('text').value.match(/[\p{L}\p{N}_]+/gu).length < 10)
	{
		info('short');
	}
	else
	{
		const request = new Request
		(
			'submit.php',
			{
				'method': 'POST',
				'headers':
				{
					'Content-Type': 'application/json'
				},
				'body': JSON.stringify
				(
					{
						'action': 'send',
						'email': document.getElementById('email').value,
						'code': document.getElementById('code').value,
						'incog': document.getElementById('incog').checked,
						'text': document.getElementById('text').value
					}
				)
			}
		);
		info('wait');
		const result = await fetch(request);
		if (result.ok === true)
		{
			const content = await result.text();
			if (content === 'sent')
			{
				localStorage.removeItem('time');
				document.getElementById('email').value = '';
				document.getElementById('code').value = '';
				document.getElementById('text').value = '';
				document.getElementById('incog').checked = false;
			}
			info(content);
		}
		else
		{
			info('vague');
		}
	}
}

function shut()
{
	halt(false);
	document.getElementById('dim').classList.remove('active');
}
